﻿#if UNITY_EDITOR
using System.Collections.Generic;
using System;
using UnityEngine;

using UnityEditor;

[ExecuteAlways]
public class SceneBlock : MonoBehaviour {
    [Header("Common")]
    public bool FlipH;
    public bool Possessable;
    public bool IsPlayer;

    [Header("Other properties")]
    public int PlayerOrder;
    public bool FloatInSpace;
    public int SpecialEffect;

    //[Header("Root")]
    //public string AttemptOrder;
    //public bool ShedEnabled;
    //public bool InnerPushEnabled;

    [Header("Hub")]
    // Hub unlockable walls
    public string unlockerScene = "_";

    // Hub area blocks
    public string areaPrefix = "_";
    public string areaName = "_";

    public void UpdateColor() {
        SpriteRenderer sprite = GetComponent<SpriteRenderer>();

        Undo.RecordObject(sprite, "asdf");

        float hue, sat, val;

        var level = GetComponent<SceneLevel>();

        if (level == null) {
            if (transform.parent == null) {
                sprite.color = Color.white;
                return;
            }

            var parent = transform.parent.GetComponent<SceneLevel>();
            hue = parent.hue;
            sat = parent.sat;
            //val = parent.val * ValScale(gameObject);
            val = parent.val * ValScale(gameObject) + 0.75f;
        }
        else {
            hue = level.hue;
            sat = level.sat;
            //val = this.val * ValScale(gameObject);
            val = level.val * ValScale(gameObject) + 0.5f;
        }

        sprite.color = Color.HSVToRGB(hue, sat, val);
    }

    public static float ValScale(GameObject obj) {
        return -0.25f * Mathf.Log((float)(obj.transform.lossyScale.x * 0.1f + 0.005), 20);
        //int depth = obj.GetComponent<Snap>().depth;
        //return Mathf.Pow(-depth;
    }
}
#endif
